/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import java.security.SecureRandom;

public final class UUIDFactory {
    private static final String TRACE_MASKT = "XUUIFACT";
    private static final String TRACE_MASKF = "XUUIFACF";
    private static final String TRACE_MASKD = "XUUIFACD";
    private static byte[] v1ClockSequence = new byte[2];
    private static byte[] v1Node = new byte[6];
    private static int v1UuidsThisTick = 0;
    private static long v1LastSystemTime = System.currentTimeMillis();
    private static final int V1_UUIDS_PER_TICK = 1024;
    private static final long MILLI_TO_100NANO_MULTIPLIER = 10000L;
    private static final long SYS100NANO_TO_UUID_OFFSET = 122192928000000000L;
    private static Object uuidLock = new Object();
    private static SecureRandom secureRandom = new SecureRandom();
    private static String nativeLibName = "jniuuidfactory";
    private static boolean nativeLibAvailable = false;
    public static final int TIME_BASED = 1;
    public static final int RANDOM_BASED = 4;

    private UUIDFactory() {
    }

    public static UUID generate() {
        return UUIDFactory.generate(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID generate(int version) {
        if (!UUIDFactory.isVersionValid(version)) {
            throw new IllegalArgumentException("Unsupported or invalid UUID version");
        }
        Object object = uuidLock;
        synchronized (object) {
            switch (version) {
                case 1: {
                    return UUIDFactory.generateVersion1UUID();
                }
                case 4: {
                    return UUIDFactory.generateVersion4UUID();
                }
            }
            Trace.trace(TRACE_MASKF, "Allowing unsupported UUIDs to be generated");
            return null;
        }
    }

    private static boolean isVersionValid(int version) {
        switch (version) {
            case 1: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static native void generateNativeUUID(int var0, byte[] var1) throws IllegalArgumentException;

    private static UUID generateVersion1UUID() {
        if (nativeLibAvailable) {
            try {
                byte[] bits = new byte[16];
                UUIDFactory.generateNativeUUID(1, bits);
                return new UUID(bits);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long timeStamp = UUIDFactory.newTimeStamp(1);
        return UUIDFactory.formatUUID(1, timeStamp, v1ClockSequence, v1Node);
    }

    private static UUID generateVersion4UUID() {
        if (nativeLibAvailable) {
            try {
                byte[] bits = new byte[16];
                UUIDFactory.generateNativeUUID(4, bits);
                return new UUID(bits);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long timeStamp = UUIDFactory.newTimeStamp(4);
        byte[] clockSequence = UUIDFactory.newClockSequence(4);
        byte[] node = UUIDFactory.newNode(4);
        return UUIDFactory.formatUUID(4, timeStamp, clockSequence, node);
    }

    private static UUID formatUUID(int version, long timeStamp, byte[] clockSequence, byte[] node) {
        byte[] bits = new byte[16];
        long timeLow = timeStamp & 0xFFFFFFFFL;
        long timeMiddle = timeStamp >> 32 & 0xFFFFL;
        long timeHighAndVersion = (long)(version << 12) | timeStamp >> 48 & 0xFFFL;
        byte clockSeqHighAndReserved = (byte)(clockSequence[0] & 0x3F | 0x80);
        byte clockSeqLow = clockSequence[1];
        bits[0] = (byte)(timeLow >>> 24);
        bits[1] = (byte)(timeLow >>> 16);
        bits[2] = (byte)(timeLow >>> 8);
        bits[3] = (byte)timeLow;
        bits[4] = (byte)(timeMiddle >>> 8);
        bits[5] = (byte)timeMiddle;
        bits[6] = (byte)(timeHighAndVersion >>> 8);
        bits[7] = (byte)timeHighAndVersion;
        bits[8] = clockSeqHighAndReserved;
        bits[9] = clockSeqLow;
        bits[10] = node[0];
        bits[11] = node[1];
        bits[12] = node[2];
        bits[13] = node[3];
        bits[14] = node[4];
        bits[15] = node[5];
        return new UUID(bits);
    }

    private static long newTimeStamp(int version) {
        long newTimeStamp = 0L;
        if (version == 4) {
            newTimeStamp = secureRandom.nextLong();
        } else {
            boolean isValidTime = true;
            long now = 0L;
            do {
                if ((now = System.currentTimeMillis()) < v1LastSystemTime) {
                    v1ClockSequence = UUIDFactory.newClockSequence(version);
                    v1UuidsThisTick = 0;
                    continue;
                }
                if (now == v1LastSystemTime) {
                    if (v1UuidsThisTick >= 1024) {
                        isValidTime = false;
                        continue;
                    }
                    ++v1UuidsThisTick;
                    continue;
                }
                v1UuidsThisTick = 0;
            } while (!isValidTime);
            v1LastSystemTime = now;
            newTimeStamp = now * 10000L;
            newTimeStamp += 122192928000000000L;
            newTimeStamp += (long)v1UuidsThisTick;
        }
        return newTimeStamp;
    }

    private static byte[] newClockSequence(int version) {
        byte[] newClockSequence = new byte[2];
        secureRandom.nextBytes(newClockSequence);
        newClockSequence[0] = (byte)(newClockSequence[0] | 0x3F);
        return newClockSequence;
    }

    private static byte[] newNode(int version) {
        byte[] newNode = new byte[6];
        secureRandom.nextBytes(newNode);
        if (version == 1) {
            newNode[0] = (byte)(newNode[0] | 0x80);
        }
        return newNode;
    }

    static {
        try {
            System.loadLibrary(nativeLibName);
            nativeLibAvailable = true;
            Trace.trace(TRACE_MASKF, "Library " + nativeLibName + " loaded successfully");
        }
        catch (Error error) {
            Trace.trace(TRACE_MASKF, "Library " + nativeLibName + " could " + "not be loaded: Error: " + error.getMessage());
        }
        v1ClockSequence = UUIDFactory.newClockSequence(1);
        v1Node = UUIDFactory.newNode(1);
    }
}

